using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This class represents exceptions that occur when VistALink system 
	/// fault messages are received. This exception usually indicates severe 
	/// problems occured at a listener side.
	/// </summary>
	public class SystemFaultException : VistALinkFaultException
	{
		/// <summary>
		/// This constructor accepts fault info object containing 
		/// information about a fault occured at server side.
		/// </summary>
		/// <param name="faultInfo">
		///		Fault info object containing information about a fault
		///		occured at server side.
		///	</param>
		public SystemFaultException( FaultInfo faultInfo)
			: base( faultInfo ) {}

		/// <summary>
		/// Constructor allowing child exceptions to declare themselves as fatal - 
		/// the ones that drop a connection.
		/// </summary>
		/// <param name="faultInfo">
		///		Fault info structure containing information about 
		///		fault occured at remote server.
		///	</param>
		///	<param name="isFatal">
		///		Flag indicating that an exception is 
		///		fatal, connection was dropped and further execution is impossible without reconnect.
		///	</param>
		protected SystemFaultException( FaultInfo faultInfo, bool isFatal ) 
			: base( faultInfo, isFatal ) {}
	}
}
